/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.decoders;

import com.akuleshov7.ktoml.TomlInputConfig;
import com.akuleshov7.ktoml.decoders.TomlAbstractDecoder;
import com.akuleshov7.ktoml.exceptions.IllegalTypeException;
import com.akuleshov7.ktoml.exceptions.InternalDecodingException;
import com.akuleshov7.ktoml.tree.nodes.TomlKeyValue;
import com.akuleshov7.ktoml.tree.nodes.TomlNode;
import com.akuleshov7.ktoml.tree.nodes.TomlStubEmptyNode;
import com.akuleshov7.ktoml.tree.nodes.TomlTable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J;\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\b\u0010\u0017\u001a\u0004\u0018\u0001H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/akuleshov7/ktoml/decoders/TomlMapDecoder;", "Lcom/akuleshov7/ktoml/decoders/TomlAbstractDecoder;", "rootNode", "Lcom/akuleshov7/ktoml/tree/nodes/TomlTable;", "config", "Lcom/akuleshov7/ktoml/TomlInputConfig;", "decodingElementIndex", "", "kotlinxIndex", "<init>", "(Lcom/akuleshov7/ktoml/tree/nodes/TomlTable;Lcom/akuleshov7/ktoml/TomlInputConfig;II)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeSerializableElement", "T", "index", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "previousValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeKeyValue", "Lcom/akuleshov7/ktoml/tree/nodes/TomlKeyValue;", "decodeKeyValue$ktoml_core", "skipStubs", "", "ktoml-core"})
public final class TomlMapDecoder
extends TomlAbstractDecoder {
    @NotNull
    private final TomlTable rootNode;
    @NotNull
    private final TomlInputConfig config;
    private int decodingElementIndex;
    private int kotlinxIndex;
    @NotNull
    private final SerializersModule serializersModule;

    public TomlMapDecoder(@NotNull TomlTable rootNode, @NotNull TomlInputConfig config, int decodingElementIndex, int kotlinxIndex) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.rootNode = rootNode;
        this.config = config;
        this.decodingElementIndex = decodingElementIndex;
        this.kotlinxIndex = kotlinxIndex;
        this.serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
    }

    public /* synthetic */ TomlMapDecoder(TomlTable tomlTable, TomlInputConfig tomlInputConfig, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(tomlTable, tomlInputConfig, n, n2);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.rootNode.getChildren().get(this.decodingElementIndex) instanceof TomlStubEmptyNode) {
            this.skipStubs();
        } else {
            this.decodingElementIndex = this.kotlinxIndex / 2;
        }
        if (this.decodingElementIndex == this.rootNode.getChildren().size()) {
            return -1;
        }
        int n = this.kotlinxIndex;
        this.kotlinxIndex = n + 1;
        return n;
    }

    public <T> T decodeSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        this.skipStubs();
        TomlNode processedNode = this.rootNode.getChildren().get(this.decodingElementIndex);
        if (processedNode instanceof TomlKeyValue) {
            object = index % 2 == 0 ? ((TomlKeyValue)((Object)processedNode)).getKey().toString() : ((TomlKeyValue)((Object)processedNode)).getValue().getContent();
        } else if (processedNode instanceof TomlTable) {
            object = index % 2 == 0 ? (Object)((TomlTable)processedNode).getName() : new TomlMapDecoder((TomlTable)processedNode, this.config, 0, 0, 12, null).decodeSerializableValue(deserializer);
        } else {
            throw new InternalDecodingException("Trying to decode " + TomlNode.prettyStr$default(processedNode, false, 1, null) + " with TomlMapDecoder, but faced an unknown type of Node");
        }
        return (T)object;
    }

    @Override
    @NotNull
    public TomlKeyValue decodeKeyValue$ktoml_core() {
        throw new IllegalTypeException("\n            You are trying to decode a nested Table " + this.rootNode.getFullTableKey() + " with a <Map> type to some primitive type.\n            For example: \n            [a]\n              [a.b]\n                  a = 2\n                  \n            should be decoded to Map<String, Map<String, Long>>, but not to Map<String, Long>\n            ", this.rootNode.getLineNo());
    }

    private final void skipStubs() {
        if (this.rootNode.getChildren().get(this.decodingElementIndex) instanceof TomlStubEmptyNode) {
            ++this.decodingElementIndex;
            this.kotlinxIndex += 2;
        }
    }
}

